<?php
//single image template
function ux_pb_module_singleimage($itemid){
	global $ux_pagebuilder; 
	$module_post = $ux_pagebuilder->item_postid($itemid);
	$moduleid = 'single-image';
	
	if($module_post){
		global $wpdb;
		
		//single image confing
		$image_src         = get_post_meta($module_post, 'module_singleimage_image', true);
		$style             = get_post_meta($module_post, 'module_singleimage_style', true);
		$align             = get_post_meta($module_post, 'module_singleimage_align', true);
		$effect            = get_post_meta($module_post, 'module_singleimage_effect', true);
		$lightbox          = get_post_meta($module_post, 'module_singleimage_lightbox', true);
		$link          	   = get_post_meta($module_post, 'module_singleimage_link', true);
		$link_newtab       = get_post_meta($module_post, 'module_singleimage_link_new_tab', true);
		$advanced_settings = get_post_meta($module_post, 'module_advanced_settings', true);
		$animation_base    = get_post_meta($module_post, 'module_scroll_animation_base', true);
		$image_optimize    = get_post_meta($module_post, 'module_singleimage_optimize_image', true);
		$enable_title      = get_post_meta($module_post, 'module_singleimage_enable_title', true);
		$enable_caption    = get_post_meta($module_post, 'module_singleimage_enable_caption', true);
		$gray_effect       = $style == 'grey' ? 'grayscale' : false;
		
		$animation_style   = $advanced_settings == 'on' ? ux_pb_module_animation_style($itemid, $moduleid) : false;
		$animation_end     = $advanced_settings == 'on' ? ux_pb_animation_end($animation_base) : false;
		
		$get_attachment    = $wpdb->get_row($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE `guid` LIKE %s", $image_src));
		$attachment_title  = get_the_title($get_attachment->ID);
		$image_alt = get_post_meta($get_attachment->ID, '_wp_attachment_image_alt', TRUE) ? get_post_meta($get_attachment->ID, '_wp_attachment_image_alt', TRUE) : $attachment_title;
		$attachment_caption = wp_get_attachment_caption($get_attachment->ID);
		$thumb_full        = $get_attachment ? wp_get_attachment_image_src($get_attachment->ID, 'full') : false;
		$img_src_full      = $image_src ? $thumb_full[0] : false;
		$data_size         = $image_src ? $thumb_full[1]. 'x' .$thumb_full[2] : false;
		$thumbPaddingTop   = false;
		if ( $image_src ) {
			if ( $thumb_full[1] > 0 && $thumb_full[2] > 0 ) {
				//$thumbPaddingTop = 'style="padding-top: ' . (intval($thumb_full[2]) / intval($thumb_full[1])) * 100 . '%;"';
			}
		}

		if( $image_optimize ) {
			$image_src = $image_optimize;
		}
		
		$link_newtab_html  = $link_newtab == 'on' ? ' target="_blank"' : false;
		$shadow_before     = $style == 'shadow' ? '<div class="single-image-shadow shadow">' : false;
		$shadow_after      = $style == 'shadow' ? '</div>' : false;
		$mouseover         = $effect == 'on' ? 'mouse-over' : false;
		$lightbox_before   = $lightbox == 'on' ? '<div data-lightbox="true"><a '.sanitize_text_field( $thumbPaddingTop ).' class="lightbox-item ux-hover-wrap" href="' .esc_url($img_src_full). '" data-size="' .$data_size. '" style="">' : '<div class="ux-hover-wrap"><a href="'.esc_url($link).'" '.sanitize_text_field($link_newtab_html).'>';
		$lightbox_after    = $lightbox == 'on' ? '</a></div>' : '</a></div>';
		$lightbox_class    = $lightbox == 'on' ? 'lightbox-photoswipe' : false;
		$image             = $image_src ? '<img alt="'.esc_attr($image_alt).'" class="single-image-img lazy ' .sanitize_html_class($gray_effect). '" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="' .esc_url($image_src). '" />' : false; 
		$title 			   = $enable_title == 'on' ? '<h6 class="single-image-tit">'.esc_html($attachment_title).'</h6>' : false;  
		$caption 		   = $enable_caption == 'on' ? '<div class="single-image-caption">'.wp_get_attachment_caption($get_attachment->ID).'</div>' : false;?>
		
		<div class="single-image <?php echo sanitize_html_class($lightbox_class); ?> <?php echo $attachment_caption; ?> <?php echo sanitize_html_class($align); ?>-ux <?php echo esc_attr($animation_style); ?>" data-animationend="<?php echo esc_attr($animation_end); ?>">
			<?php 
				echo balanceTags($lightbox_before);
				echo balanceTags($shadow_before);
				echo balanceTags($image);
				echo balanceTags($shadow_after);
				echo balanceTags($lightbox_after);
				echo wp_kses_post($title);
				echo wp_kses_post($caption);
			?>
		</div>
        
	<?php
	}
}
add_action('ux-pb-module-template-single-image', 'ux_pb_module_singleimage');

//single image select fields
function ux_pb_module_singleimage_select($fields){
	$fields['module_singleimage_style'] = array(
		array('title' => __('Standard','ux'), 'value' => 'no'),
		array('title' => __('Shadow','ux'), 'value' => 'shadow'),
		array('title' => __('Grey','ux'), 'value' => 'grey')
	);
	
	$fields['module_singleimage_align'] = array(
		array('title' => __('Left','ux'), 'value' => 'left'),
		array('title' => __('Center','ux'), 'value' => 'singleimage-center'),
		array('title' => __('Right','ux'), 'value' => 'right')
	);
	
	return $fields;
}
add_filter('ux_pb_module_select_fields', 'ux_pb_module_singleimage_select');

//single image box config fields
function ux_pb_module_singleimage_fields($module_fields){
	$module_fields['single-image'] = array(
		'id' => 'single-image',
		'animation' => true,
		'title' => __('Single Image','ux'),
		'item' =>  array(
			array('title' => __('Image','ux'),
				  'description' => __('Select image','ux'),
				  'type' => 'upload',
				  'name' => 'module_singleimage_image'),
				  
			array('title' => __('Style','ux'),
				  'description' => __('Select a style for the image','ux'),
				  'type' => 'select',
				  'name' => 'module_singleimage_style',
				  'default' => 'no'),

			array('title' => __('Algin','ux'),
				  'description' => '',
				  'type' => 'select',
				  'name' => 'module_singleimage_align',
				  'default' => 'left'),
				  
			array('title' => __('Mouseover Effect','ux'),
				  'description' => __('Enable the mouseover effect','ux'),
				  'type' => 'switch',
				  'name' => 'module_singleimage_effect',
				  'default' => 'on'),
				  
			array('title' => __('Lightbox','ux'),
				  'description' => __('Enable the Lightbox','ux'),
				  'type' => 'switch',
				  'name' => 'module_singleimage_lightbox',
				  'default' => 'on'),

			array('title' => __('Enable Title','ux'),
				  'description' => '',
				  'type' => 'switch',
				  'name' => 'module_singleimage_enable_title',
				  'default' => 'off'),

			array('title' => __('Enable Caption','ux'),
				  'description' => '',
				  'type' => 'switch',
				  'name' => 'module_singleimage_enable_caption',
				  'default' => 'off'),

			array('title' => __('Show an Optimized Image','ux'),
				  'description' => __('optional','ux'),
				  'type' => 'upload',
				  'name' => 'module_singleimage_optimize_image',
				  'default' => ''),

			array('title' => __('External link','ux'),
				  'description' => '',
				  'type' => 'text',
				  'name' => 'module_singleimage_link',
				  'default' => '',
				  'control' => array(
					  'name' => 'module_singleimage_lightbox',
					  'value' => 'off'
				  )),

			array('title' => __('Open link in a new tab','ux'),
				  'description' => __('Enable the mouseover effect','ux'),
				  'type' => 'switch',
				  'name' => 'module_singleimage_link_new_tab',
				  'default' => 'off',
				  'control' => array(
					  'name' => 'module_singleimage_lightbox',
					  'value' => 'off'
				  )),
				  
			array('title' => __('Advanced Settings','ux'),
				  'description' => __('magin and animations','ux'),
				  'type' => 'switch',
				  'name' => 'module_advanced_settings',
				  'default' => 'off'),
				  
			array('title' => __('Bottom Margin','ux'),
				  'description' => __('the spacing outside the bottom of module','ux'),
				  'type' => 'select',
				  'name' => 'module_bottom_margin',
				  'default' => 'bottom-space-40',
				  'control' => array(
					  'name' => 'module_advanced_settings',
					  'value' => 'on'
				  ))
		)
	);
	return $module_fields;
	
}
add_filter('ux_pb_module_fields', 'ux_pb_module_singleimage_fields');
?>